using System;

namespace gov.va.med.vbecs.BOL
{
		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/28/2004</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>Summary description for AntigenNegativeMessage.</summary>

		#endregion

	public class AntigenNegativeMessage
	{
		#region Variables
		private int _antigenTypeID;
		private string _antigenName;
		private string _antibodyName;
		private bool _tested;
		private Common.TestResult _testResult;

		#endregion

		#region Constructors

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3614"> 
		///		<ExpectedInput>Valid Antigen typing ID, name, tested flag and test result</ExpectedInput>
		///		<ExpectedOutput>Populated AntigenNegativeMessage object initialized</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3615"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="antigenTypeID"></param>
		/// <param name="antigenName"></param>
		/// <param name="antibodyName"></param>
		/// <param name="tested"></param>
		/// <param name="testResult"></param>
		public AntigenNegativeMessage(int antigenTypeID, string antigenName, string antibodyName, bool tested, Common.TestResult testResult)
		{
			_antigenTypeID = antigenTypeID;
			_antigenName = antigenName;
			_antibodyName = antibodyName;
			_tested = tested;
			_testResult = testResult;
		}

		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="217"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>int</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="218"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// AntigenTypeId
		/// </summary>
		public int AntigenTypeId
		{
			get
			{
				return _antigenTypeID;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="219"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="220"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// AntigenName
		/// </summary>
		public string AntigenName
		{
			get
			{
				return _antigenName;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/30/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5953"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="5954"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// AntibodyName
		/// </summary>
		public string AntibodyName
		{
			get
			{
				return _antibodyName;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="221"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="222"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Tested - boolean indicates whether or not there are test results for 
		/// this antigen.
		/// </summary>
		public bool Tested
		{
			get
			{
				return _tested;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="223"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Common.TestResult</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="224"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// TestResult - Indicates the test results in the form of an enumeration.
		/// </summary>
		public Common.TestResult TestResult
		{
			get
			{
				return _testResult;
			}
		}

		#endregion
	}
}
